Include([[Data/levels/include/level_utils.lua]])

-- lerp(a, b, k)
-- Returns a linear interpolation between a and b, based on the
-- coefficient k when it is in [0,1]. If k is outside this range,
-- the function returns extrapolated values along the same line.
function math.lerp(a, b, k)
    return a * (1-k) + b * k
end

function math.round(a)
    return math.floor(a + 0.5)    
end


function string:split(p_sep)
    local result = {}
    for token in string.gmatch(self, "[^,]+") do
       table.insert(result, token)
    end
    
    return result
end

local lastCaptureAdjustment = -1
if GameWorld:GetParamInt("Custom:StartMutations") > 0 then lastCaptureAdjustment = 0 end
local maxCaptures = GameWorld:GetParamInt("Custom:HiveCount") - 1
local captureMutations = GameWorld:GetParamInt("Custom:MutationCount") - GameWorld:GetParamInt("Custom:StartMutations")
local capturesPerMuta = math.floor(math.max((maxCaptures+lastCaptureAdjustment) / (captureMutations+lastCaptureAdjustment), (maxCaptures) / (captureMutations)))
local coveredCaptures = math.max(0, capturesPerMuta * (captureMutations+lastCaptureAdjustment)) - lastCaptureAdjustment
local queuePaddingCt = math.ceil((maxCaptures - coveredCaptures) * 0.3)
local queuePadding = {}

for i = 1, queuePaddingCt do
    table.insert(queuePadding, [[ZU_NONE]])
end


Level =
{
	MapSkinFilename = LevelUtils.PickRandomChoice(LevelUtils.GetAllSkinFilenames()),
	MapGenScript = function ()
	
		--Map Geometry
		MapGeometry:Randomize(GameWorld:GetParamFloat("Custom:MapSize"), GameWorld:GetParamFloat("Custom:MapFeatures"))
		MapEntities:SetParameters(LevelUtils.MapGenDefaults)
		MapEntities:GenerateLocations()
	
		local clusterK = GameWorld:GetParamFloat("Custom:HiveClustering")
		local hiveCount = GameWorld:GetParamInt("Custom:HiveCount")
		local easyPoints = math.round(math.min(math.lerp(6,0,math.pow(clusterK, 0.3)), hiveCount))
        
        local hiveCountLeft = hiveCount - easyPoints
        local hiveDifficultyCount = {0, 0, 0, 0, 0, 0}
        
        local highestLevel = (math.lerp(1,6,clusterK))
        local lowestLevel = (math.lerp(1,3,clusterK))
        local superClusterLevel = math.round(math.lerp(highestLevel,lowestLevel,math.pow(clusterK,2.0)))
        
        local reductionSteps = math.floor((highestLevel - lowestLevel)/2) + 1
        local reductionCtrMax = math.floor(hiveCountLeft / reductionSteps)
        local reductionCtr = reductionCtrMax
        
        while hiveCountLeft > 0 do
            for i=math.round(highestLevel), math.round(lowestLevel), -1 do
                if hiveCountLeft <= 0 then
                    break
                end
                
                hiveDifficultyCount[i] = hiveDifficultyCount[i] + 1
                reductionCtr = reductionCtr - 1
                hiveCountLeft = hiveCountLeft - 1
            end
            
            
            if reductionCtr <= 0 then
                lowestLevel = math.max(lowestLevel + 1, highestLevel)
                highestLevel = math.max(highestLevel - 1, lowestLevel)
                
                reductionCtr = reductionCtrMax
            end           
            
        end
 		
		for difficulty, numHivesOfThisDifficulty in ipairs(hiveDifficultyCount) do
--[[
			if difficulty == 1 then
			    Log(easyPoints+numHivesOfThisDifficulty .. " x PlaceCapPoint(" ..  difficulty-1 .. ")")
            else
			    Log(numHivesOfThisDifficulty .. " x PlaceCapPoint(" ..  difficulty-1 .. ")")
            end
--]]
            for i=1, numHivesOfThisDifficulty do
			    local minHives = -1
			    if difficulty > superClusterLevel then minHives = 1 end
				MapEntities:PlaceCapPoint(false, minHives, difficulty-1, true, LevelUtils.MapGenDefaults.CapPtExclusionRadius, "");
			end
		end		
		
		for i=1, easyPoints do
		    MapEntities:PlaceCapPoint(false, -1, 0, false, LevelUtils.MapGenDefaults.CapPtExclusionRadius, "");
        end
		
		--local homeBase = MapEntities:PlaceCapPoint(true, -1, 0, false, 90.0, "");
		--GameWorld:AddMarines(homeBase:GetPos(), GameWorld:GetStartingTeamSize())
		--GameWorld:ResetCamera(homeBase:GetPos())
		local homePos = vect2f()
		local homePlaced = MapEntities:GetStartingPlace(homePos, 90.0)
        
        if homePlaced then
            GameWorld:AddMarines(homePos, GameWorld:GetStartingTeamSize())
            GameWorld:ResetCamera(homePos)
            --GameWorld:FocusCameraOn(homeBase)
            
            local bunker = GameWorld:CreateEntity("PropBuilding", "xenoBunker", homePos)
            
            GameWorld:RegisterRaidTarget(bunker)
            GameWorld:RegisterRespawnSource(bunker)
            
            local building = bunker:ToCHumanBuilding()
            building:CompleteBuilding()
            
            BunkerLostScript:OnBunkerCreated()
		end
		
		--Alien support structs
		local structParamTranslate = {}
		local structTypeList = {}
		
		structParamTranslate["Custom:MortarOn"]     = EntityArranger_EBType.BT_MORTAR
		structParamTranslate["Custom:TurretOn"]     = EntityArranger_EBType.BT_TURRET
		structParamTranslate["Custom:ShieldOn"]     = EntityArranger_EBType.BT_MEDICENT
		structParamTranslate["Custom:ProtohiveOn"]  = EntityArranger_EBType.BT_NECRONODE
		structParamTranslate["Custom:BulwarkOn"]    = EntityArranger_EBType.BT_HARDPOINT
		structParamTranslate["Custom:GuardiansOn"]  = EntityArranger_EBType.BT_HARDPOINT_GUARDS
		structParamTranslate["Custom:SiegeOn"]      = EntityArranger_EBType.BT_SIEGE
		structParamTranslate["Custom:MimicOn"]      = EntityArranger_EBType.BT_HARDPOINT_MIMICS
	
	    for key, value in pairs(structParamTranslate) do
	        if GameWorld:GetParamBool(key) then
	            table.insert(structTypeList, value)
            end
        end
		
		MapEntities:PlaceEnemyStuctures( GameWorld:GetParamFloat("Custom:ExtraDefense"),
                                         structTypeList);
		
		--Place crates
		for i=1, GameWorld:GetParamInt("Custom:CratesBP") do
			MapEntities:PlaceBPCrate(20.0, 60.0, 15.0);
		end
		
		for i=1, GameWorld:GetParamInt("Custom:CratesAP") do
			MapEntities:PlaceAPCrate(14.0, 20.0, 6.0);
		end		
	end,
	
	Parameters =
	{
		MarineCount 		= GameWorld:GetParamInt("Custom:TeamSize"),
		MaxHiveLevel 		= GameWorld:GetParamInt("Custom:HiveLevel"),
		MaxSpawnRate 		= GameWorld:GetParamInt("Custom:SpawnRate"),
		StartBPMultiplier 	= 1.0,
		BPGainMultiplier    = 1.0,
		
		StartBuildPoints    = GameWorld:GetParamInt("Custom:StartBP"),
		PointGainPerCapture = GameWorld:GetParamInt("Custom:RewardBP"),
		
		DefaultHiveTowerCount 	= GameWorld:GetParamInt("Custom:TowerCount"),
		HiveLifecycleK      	= GameWorld:GetParamFloat("Custom:HiveRespawn"),
	},
	Rules = 
	{
		AutoCapture 	= true,			--Destroying hives automatically counts as a capture
		NoPushback		= false,		--Can the player's points be captured?
		NoTowerRespawn  = true,        	--Can the hive towers respawn?
		WeakenHiveOnCap = false,        --Do captures halve defensive strength?
		DisableLockdown = false,        --Turn off emergency help is player is behind
		SmartMutations	= GameWorld:GetParamBool("Custom:MaliciousMutations"),
	},
	Mutations =
	{
		CapturesPerMutation = capturesPerMuta,
		MaxMutations = GameWorld:GetParamInt("Custom:MutationCount"),
		Default = [[disabled]],
		Active = {},
		Queue =	queuePadding,
		Disabled = {},
		Inactive = string.split(GameWorld:GetParam("Custom:PossibleMutations"), ","),
		Randomize = true
	},
	MarineUpgrades = 
	{
		RandomResearchLockCount = GameWorld:GetParamInt("Custom:LockTech"),
		
		Active =
		{
		},
		Inactive =
		{
		},	
		Locked =
		{
		},			
	},
	
	OnDebugCall = function (mousePos)
		GameWorld:ApplyNextMutation(false)
	end,
	
	GetLevelReward = function ()
		return GameWorld:GetStat([[ST_XENOCIDE_REWARD]])
	end
}

XenoTimer = nil
------------------------------------------------------------------------------- Level Init
LevelInit = LevelUtils.MakeGoal(
	nil,
	{[[NT_BEGIN_GAME]]},
	function (self, p_type, p_entId, p_pos, p_other)		
		XenoTimer =
        LevelUtils.CreateXenocideTimer(120000, MutationWatcher.baseTimer,
                                                     	function ()
															GameWorld:GameOver(true)		
															CaptureAllBonus:Disable()
														end)
		LevelUtils.CreateXenocideRewardCounter()
		CaptureAllBonus:Enable()
		
		for i = 1, GameWorld:GetParamInt("Custom:StartMutations") do
		    ScriptMgr:DoDelayedCall(2000 + (i-1)*300, function () GameWorld:ApplyNextMutation(true); end) --Random Mutation
		end
		
		--ScriptMgr:DoDelayedCall(1000, function () GameWorld:MakeAnnouncement("Evacuation\nIn 2 Minutes"); end)
		
		self:Disable()
	end)
LevelInit:Enable()

------------------------------------------------------------------------------- Tracked objective for killing everything
local bonusSize = 4000
CaptureAllBonus = LevelUtils.MakeGoal(
	function (self)
		GameWorld:SetUIVisibility("Objectives", true)
		local commaSeparatedValue = string.gsub(bonusSize, "(%d)(%d%d%d)$", "%1,%2", 1)
		GameWorld:AddObjective("bonusobj", "Kill all hives for a $" .. commaSeparatedValue .. " bonus")
		
		--local text_hdl = GameWorld:ShowText("We're short on time squad!\nKill all you can before the clock runs out.\nBonus pay for wiping the area clean, you hear?", "Sarge")
		--ScriptMgr:DoDelayedCall(8000, function () text_hdl:ClearText(); end)
	end,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ChangeObjectiveStatus("bonusobj", [[complete]])
	
		local commaSeparatedValue = string.gsub(bonusSize, "(%d)(%d%d%d)$", "%1,%2", 1)
		GameWorld:MakeAnnouncement("$" .. commaSeparatedValue .. "\nBonus Earned")
		GameWorld:ChangeStat("ST_XENOCIDE_REWARD", bonusSize)
	
		GameWorld:ClearText()
		GameWorld:GameOver(true)
	
	    BunkerLostScript:Disable()
		self:Disable()
	end)
	
	
------------------------------------------------------------------------------- Mutation has happened!
MutationWatcher = LevelUtils.MakeGoal(
	function (self)
	
		local rewardValue = tonumber(GameWorld:GetParam("ContractReward"))
		if not rewardValue then rewardValue = 5000 end
	
	    self.multiplier         = rewardValue / 5000 * 0.3
	    if XenoRewardMultiplier ~= nil then
	        self.multiplier = self.multiplier * XenoRewardMultiplier
	    end
	    
	    self.baseTimer          = 50000
	    self.timerReward        = self.baseTimer
	    self.KillReward_Mobile  = 1*self.multiplier
        self.KillReward_Tower   = 100*self.multiplier
        self.KillReward_Hive    = 2000*self.multiplier
	    bonusSize = math.floor(bonusSize*self.multiplier)
	
        GameWorld:SetParam("KillReward_Mobile", self.KillReward_Mobile*self.multiplier)
        GameWorld:SetParam("KillReward_Tower", self.KillReward_Tower*self.multiplier)
        GameWorld:SetParam("KillReward_Hive", self.KillReward_Hive*self.multiplier)
	
	end,
	
	{[[NT_MUTATION_EVOLVED]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		
		local mutationInfo = LevelUtils.mutationWeights[p_other]
		if mutationInfo == nil then
		    return
        end
		
		bonusSize = math.floor(bonusSize + (mutationInfo.hivesReward + mutationInfo.towersReward*10 + mutationInfo.mobilesReward*750)*self.multiplier)
	    self.timerReward        = self.timerReward + 10000 + mutationInfo.timer*1000 --math.max(self.baseTimer + mutationInfo.timer*1000, self.timerReward)
	    self.KillReward_Mobile  = self.KillReward_Mobile + mutationInfo.mobilesReward*self.multiplier
        self.KillReward_Tower   = self.KillReward_Tower + mutationInfo.towersReward*self.multiplier
        self.KillReward_Hive    = self.KillReward_Hive + mutationInfo.hivesReward*self.multiplier
        
		local commaSeparatedValue = string.gsub(bonusSize, "(%d)(%d%d%d)$", "%1,%2", 1)
        GameWorld:ChangeObjectiveText("bonusobj", "Kill all hives for a $" .. commaSeparatedValue .. " bonus")
         XenoTimer:ChangeCaptureIncrement(self.timerReward)
        GameWorld:SetParam("KillReward_Mobile", self.KillReward_Mobile)
        GameWorld:SetParam("KillReward_Tower", self.KillReward_Tower)
        GameWorld:SetParam("KillReward_Hive", self.KillReward_Hive)
		
	end)
MutationWatcher:Enable()

------------------------------------------------------------------------------- Capture Script
CaptureScript = LevelUtils.MakeGoal(
	nil,
	
	{[[NT_POINT_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		local bunker = GameWorld:CreateEntity("PropBuilding", "xenoBunker", p_pos)
		GameWorld:RegisterRaidTarget(bunker)
		GameWorld:RegisterRespawnSource(bunker)
		
		DoAirstrike(p_pos)
		
		BunkerLostScript:OnBunkerCreated()
	end) 
CaptureScript:Enable()

-- Do a single airstrike
function DoAirstrike(p_strikePos)
    local dir = vect2f(1.0, 0.0)
    dir:Rotate(GetRandomRange(0.0, math.pi*2))
   
    local chopper = GameWorld:SpawnChopper(dir, p_strikePos)    
    chopper:SetMission(ChopperOrder.CO_AIRSTRIKE_MISSILE, p_strikePos, "")
end

------------------------------------------------------------------------------- Bunker lost 
BunkerLostScript = LevelUtils.MakeGoal(
	function (self)
        self.bunkers_intact = 0
        self.bunker_reward_table = {}  
    end,
	
	{[[NT_ENTITY_DESTROYED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		
        if p_entId ~= "xenoBunker" then
            return
        end

        self.bunkers_intact = self.bunkers_intact - 1

        if self.bunkers_intact <= 0 then
            GameWorld:GameOver(true)
            CaptureAllBonus:Disable()
        else
            local curReward = GameWorld:GetStat([[ST_XENOCIDE_REWARD]])
            local penalty = self.bunker_reward_table[#self.bunker_reward_table]
            penalty = math.min(penalty, curReward)
            penalty = math.floor(penalty)
            
            table.remove(self.bunker_reward_table)

            GameWorld:ChangeStat([[ST_XENOCIDE_REWARD]], -penalty)
			local commaSeparatedValue = string.gsub(penalty, "(%d)(%d%d%d)$", "%1,%2", 1)
            GameWorld:MakeAnnouncement("BUNKER DOWN\n-$" .. commaSeparatedValue)
        end
	end,
	
	function (self)
	end)
BunkerLostScript:Enable()

function BunkerLostScript:OnBunkerCreated()

    self.bunkers_intact = self.bunkers_intact + 1
    
    local penalty = MutationWatcher.KillReward_Mobile*500 +
                    MutationWatcher.KillReward_Tower*10 +
                    MutationWatcher.KillReward_Hive;
    
    table.insert(self.bunker_reward_table, penalty)
    
end